/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.toy.lang;

public class TExceptionType {
    public static final String[] FAMILIES = new String[]{"Uninitialized Exceptions", "Overflow Exceptions", "Out of Bounds Exceptions"};
    public static final int UNINITIALIZED_FAMILY = 0;
    public static final int OVERFLOW_FAMILY = 1;
    public static final int OUT_OF_BOUNDS_FAMILY = 2;
    public static final TExceptionType REGISTER_UNINITIALIZED = new TExceptionType(0, "Register Uninitialized Exception", 0, "The register that an operation referenced has not been defined.");
    public static final TExceptionType MEMORY_UNINITIALIZED = new TExceptionType(1, "Memory Uninitialized Exception", 0, "The memory memory that a load operation referenced has not been defined.");
    public static final TExceptionType COMMAND_UNINITIALIZED = new TExceptionType(2, "Command Uninitialized Exception", 0, "The memory memory to which the program counter points has not been defined.");
    public static final TExceptionType OVERFLOW = new TExceptionType(3, "Overflow Exception", 1, "The result of an arithmatic operation was not between between -32768 and 32767.");
    public static final TExceptionType SHIFT_OUT_OF_BOUNDS = new TExceptionType(4, "Shift Magnitude Out Of Bounds Exception", 2, "The shift operator was used with an invalid shift magnitude; shift magnitudes must be in the closed interval [0000, 000F].");
    public static final TExceptionType PC_OUT_OF_BOUNDS = new TExceptionType(5, "Program Counter Out Of Bounds Exception", 2, "The execution or increment phase attempted to assign an invalid value to the program counter; memory locations range from 00 to FF (inclusive).");
    public static final TExceptionType REGISTER_OUT_OF_BOUNDS = new TExceptionType(6, "Register Index Out Of Bounds Exception", 2, "The execution cycle attempted to change R[0], which is a constant.");
    public static final TExceptionType MEM_OUT_OF_BOUNDS = new TExceptionType(7, "Memory Address Out Of Bounds Exception", 2, "The execution cycle attempted to load from or store to an invalid memory location; memory locations range from 00 to FF (inclusive).");
    public static final TExceptionType[] TYPES = new TExceptionType[]{REGISTER_UNINITIALIZED, MEMORY_UNINITIALIZED, COMMAND_UNINITIALIZED, OVERFLOW, SHIFT_OUT_OF_BOUNDS, PC_OUT_OF_BOUNDS, REGISTER_OUT_OF_BOUNDS, MEM_OUT_OF_BOUNDS};
    private int hashCode;
    private String name;
    private int family;
    private String description;

    private TExceptionType(int hashCode, String name, int family, String description) {
        this.hashCode = hashCode;
        this.name = name;
        this.family = family;
        this.description = description;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String getName() {
        return this.name;
    }

    public int getFamily() {
        return this.family;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name;
    }
}

